//=============================================================================
// PictureColorFilter.js
//=============================================================================

/*:
 * @plugindesc Apply saturation and brightness filter to all pictures in the game.
 * 
 * @param Saturation
 * @desc Saturation level to apply to pictures (-100 to 100)
 * @default 0
 * 
 * @param Brightness
 * @desc Brightness level to apply to pictures (-255 to 255)
 * @default 0
 * 
 * @help PictureColorFilter.js
 * 
 * This plugin allows you to apply saturation and brightness filter
 * to all pictures in the game.
 * 
 * To adjust the saturation and brightness levels, set the parameters
 * 'Saturation' and 'Brightness' in the plugin manager.
 * 
 */

(function() {
    var parameters = PluginManager.parameters('PictureColorFilter');
    var saturation = parseInt(parameters['Saturation']);
    var brightness = parseInt(parameters['Brightness']);

    // Applying filter to all pictures
    var _Sprite_Picture_updateBitmap = Sprite_Picture.prototype.updateBitmap;
    Sprite_Picture.prototype.updateBitmap = function() {
        _Sprite_Picture_updateBitmap.call(this);
        this.applyColorFilter();
    };

    Sprite_Picture.prototype.applyColorFilter = function() {
        var bitmap = this.bitmap;
        if (bitmap && bitmap._canvas) {
            var context = bitmap._context;
            if (context) {
                context.save();
                var colorMatrix = [
                    1, 0, 0, 0, brightness,
                    0, 1, 0, 0, brightness,
                    0, 0, 1, 0, brightness,
                    0, 0, 0, 1, 0
                ];
                var colorMatrixFilter = new PIXI.filters.ColorMatrixFilter();
                colorMatrixFilter.desaturate(saturation / 100, true);
                colorMatrixFilter.brightness(brightness / 255, true);
                this.filters = [colorMatrixFilter];
                context.restore();
            }
        }
    };
})();
